/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.IVWAttrUI;
import filenet.vw.toolkit.utils.mapui.VWImageAttrUI;
import filenet.vw.toolkit.utils.mapui.VWTextAttrUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;

public class VWLabelUI
extends JComponent {
    private static int s_interspace = 2;
    private static int s_border = 1;
    private int m_totalWidth = 0;
    private int m_totalHeight = 0;
    private Vector m_attributes = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(IVWAttrUI attribute) {
        try {
            Vector vector = this.m_attributes;
            synchronized (vector) {
                this.m_attributes.add(attribute);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAttributes() {
        Vector vector = this.m_attributes;
        synchronized (vector) {
            this.m_attributes.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g, Point centerPt, boolean paintBg) {
        try {
            this.calcDimension(g);
            int rectWidth = this.m_totalWidth + s_border * 2;
            int rectHeight = this.m_totalHeight + s_border * 2;
            int rectX = centerPt.x - rectWidth / 2;
            int rectY = centerPt.y - rectHeight / 2;
            if (paintBg) {
                Color currentColor = g.getColor();
                g.setColor(Color.white);
                g.fillRect(rectX, rectY, rectWidth, rectHeight);
                g.setColor(currentColor);
            }
            int x = rectX + 1;
            int y = rectY + 1;
            Vector vector = this.m_attributes;
            synchronized (vector) {
                for (int i = 0; i < this.m_attributes.size(); ++i) {
                    IVWAttrUI attrUI = (IVWAttrUI)this.m_attributes.get(i);
                    switch (attrUI.getUIType()) {
                        case 1: {
                            VWImageAttrUI imageAttrUI = (VWImageAttrUI)attrUI;
                            g.drawImage(imageAttrUI.getImage(), x, y, this);
                            break;
                        }
                        case 2: {
                            VWTextAttrUI textAttrUI = (VWTextAttrUI)attrUI;
                            int textY = centerPt.y + textAttrUI.getDescent(g) + 1;
                            g.drawString(textAttrUI.getText(), x, textY);
                            break;
                        }
                    }
                    x += attrUI.getWidth(g) + s_interspace;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printComponent(Graphics2D g, Point centerPt, int pageX, int pageY, int pageX2, int pageY2, boolean printBg) {
        block11: {
            try {
                this.calcDimension(g);
                int rectWidth = this.m_totalWidth + s_border * 2;
                int rectHeight = this.m_totalHeight + s_border * 2;
                int rectX = centerPt.x - pageX - rectWidth / 2;
                int rectY = centerPt.y - pageY - rectHeight / 2;
                int labelXul = centerPt.x - rectWidth / 2;
                int labelYul = centerPt.y - rectHeight / 2;
                int labelXlr = labelXul + rectWidth;
                int labelYlr = labelYul + rectHeight;
                if ((labelXul < pageX || labelXul > pageX2 || labelYul < pageY || labelYul > pageY2) && (labelXlr < pageX || labelXlr > pageX2 || labelYlr < pageY || labelYlr > pageY2)) break block11;
                if (printBg) {
                    Color currentColor = g.getColor();
                    g.setColor(Color.white);
                    g.fillRect(rectX, rectY, rectWidth, rectHeight);
                    g.setColor(currentColor);
                }
                int x = rectX + 1;
                int y = rectY + 1;
                Vector vector = this.m_attributes;
                synchronized (vector) {
                    for (int i = 0; i < this.m_attributes.size(); ++i) {
                        IVWAttrUI attrUI = (IVWAttrUI)this.m_attributes.get(i);
                        switch (attrUI.getUIType()) {
                            case 1: {
                                VWImageAttrUI imageAttrUI = (VWImageAttrUI)attrUI;
                                g.drawImage(imageAttrUI.getImage(), x, y, this);
                                break;
                            }
                            case 2: {
                                VWTextAttrUI textAttrUI = (VWTextAttrUI)attrUI;
                                int textY = centerPt.y - pageY + 1 + textAttrUI.getDescent(g);
                                g.drawString(textAttrUI.getText(), x, textY);
                                break;
                            }
                        }
                        x += attrUI.getWidth(g) + s_interspace;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public int getWidth(Graphics g) {
        this.calcDimension(g);
        return this.m_totalWidth;
    }

    public int getHeight(Graphics g) {
        this.calcDimension(g);
        return this.m_totalHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcDimension(Graphics g) {
        try {
            this.m_totalHeight = 0;
            this.m_totalWidth = 0;
            Vector vector = this.m_attributes;
            synchronized (vector) {
                for (int i = 0; i < this.m_attributes.size(); ++i) {
                    IVWAttrUI attrUI = (IVWAttrUI)this.m_attributes.get(i);
                    this.m_totalWidth += attrUI.getWidth(g);
                    int height = attrUI.getHeight(g);
                    this.m_totalHeight = this.m_totalHeight > height ? this.m_totalHeight : height;
                }
                this.m_totalWidth += s_interspace * (this.m_attributes.size() - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

